setwd("P:/JK Australia Manuscripts")
EUC_BIOMASS<-read.csv("EUC_BIOMASS.csv",sep=",", header=TRUE)
names(EUC_BIOMASS)
str(EUC_BIOMASS)
EUC_BIOMASS$H2O<-factor(EUC_BIOMASS$H2O,levels=c("High water","Low water"))
windows(width=7.5, height=7.5) #, pointsize=18)
par(mar=c(4.5,4.5,1,1)) 
par(xaxs="i",yaxs="i")
par(las=1)
with(EUC_BIOMASS,plot(wue[ST=="PILAD"]~ite[ST=="PILAD"],xlim=c(0,30),ylim=c(0,10),col="blue",pch=1,xlab="",ylab="",cex.axis=1.25))
with(EUC_BIOMASS,points(wue[ST=="PILAND"]~ite[ST=="PILAND"],col="blue",pch=16,cex=1.25))
with(EUC_BIOMASS,points(wue[ST=="PILEND"]~ite[ST=="PILEND"],col="red",pch=16,cex=1.25))
with(EUC_BIOMASS,points(wue[ST=="PILED"]~ite[ST=="PILED"],col="red",pch=1,cex=1.25))
A<-with(EUC_BIOMASS,lm(wue[Species=="PIL"]~ite[Species=="PIL"]))
summary(A)
abline(A,lwd=2)
with(EUC_BIOMASS,points(wue[ST=="POPAD"]~ite[ST=="POPAD"],col="blue",pch=2,cex=1.25))
with(EUC_BIOMASS,points(wue[ST=="POPAND"]~ite[ST=="POPAND"],col="blue",pch=17,cex=1.25))
with(EUC_BIOMASS,points(wue[ST=="POPEND"]~ite[ST=="POPEND"],col="red",pch=17,cex=1.25))
with(EUC_BIOMASS,points(wue[ST=="POPED"]~ite[ST=="POPED"],col="red",pch=2,cex=1.25))
B<-with(EUC_BIOMASS,lm(wue[Species=="POP"]~ite[Species=="POP"]))
summary(B)
abline(B,lty=2,lwd=2)
text(25,3.5,"Eucalyptus pilularis",font=4)
with(EUC_BIOMASS,legend(22.5,3.5, legend=c(expression(aC[a]-W,aC[a]-D,eC[a]-W,eC[a]-D)),bty="n",pch=c(16,1,16,1),pt.cex=1.25,col=c("blue","blue","red","red")))
text(25,1.75,"Eucalyptus populnea",font=4)
with(EUC_BIOMASS,legend(22.5,1.75, legend=c(expression(aC[a]-W,aC[a]-D,eC[a]-W,eC[a]-D)),bty="n",pch=c(17,2,17,2),pt.cex=1.25,col=c("blue","blue","red","red")))
mtext(side = 1, text =expression(bold("ITE")), line = 2.5,font=2, cex=1.0)
mtext(side = 1, text =expression(bold((mu*mol ~ CO[2] ~ mmol^-1 ~ H[2]*O))), line=3.5,
      font=2,cex=0.9)
par(las=3)
mtext(side = 2, text =expression(bold("WUE")), line = 3.5,font=2, cex=1.0)
mtext(side = 2, text =expression(bold((mmol ~ C ~ mol^-1 ~ H[2]*O))), line=2.5,
      font=2,cex=0.9)